<?php

namespace App\Http\Controllers\AdminAuth;

use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\Session;
use Yajra\Datatables\Datatables;
use Illuminate\Support\Facades\Auth;
use App\Model\Category;


class CategoryController extends Controller {

    private $data = array(
        'route' => 'admin.category.',
        'title' => 'Category',
        'menu' => 'category',
        'submenu' => '',
    );

    public function __construct() {
        $this->middleware(['permission:publish |category view|category add|category edit|category delete']);
    }

    private function _validate($request, $id = null) {
        $this->validate($request, [
            'name' => 'required|max:255',
			/*'image' => (!empty($id)?'mimes:jpeg,png,jpg,gif,svg|max:2048':'required|mimes:jpeg,png,jpg,gif,svg|max:2048'),*/
        ]);
    }

    public function index(Request $request) {

        abort_unless(Auth::guard('admin')->user()->hasAnyPermission(['category view']), 403);

        if($request->has('export') && ($request->get('export')=='xlsx' || $request->get('export')=='csv')){
           $categories = Category::select(['name','image','status','created_at','updated_at'])->orderBy('name','ASC')->get()->toArray();
           $this->exportFile($request->get('export'), 'category', ['Name','Image','Status', 'Created At', 'Updated At'], $categories);
        }
        
        if ($request->ajax()) {
            $records = Category::select('*')
                    ->orderBy('sequence','ASC');
            
            return Datatables::of($records)
			        ->addColumn('deletemultiple', function ($record) {
						return '<input type="checkbox" name="record_id" value="'.$record->id.'" />';
					})
                    ->editColumn('sequence', function ($record) {
                        return '<input style="width:100px" type="text" class="form-control txt_inline_edit inline_update" name="" value="'.$record['sequence'].'" row_id="'.$record['id'].'" field="sequence" ajax_url="'. route($this->data['route'] . 'update',$record['id']).'" />';
                    })
                    ->addColumn('image', function ($record) {
                        if(!empty($record['image_url'])){
                            return '<a href= "'. url($record->image_url).'" target="_blank" ><img src="'.$record->image_url.'" width="100" ></a>';
                        }else{
                            return '';
                        }
                    })
                    ->addColumn('image_size', function ($record) {
                        if (file_exists('./public/storage/' . $record['image'])) {
                            $original = !empty($record['image']) ? FileSizeConvert(filesize('./public/storage/' . $record['image'])) : '';
                        } else {
                            $original = 'Not found';
                        }
                        if (file_exists('./public/storage/thumb/' . $record['image'])) {
                            $thumb = !empty($record['image']) ? FileSizeConvert(filesize('./public/storage/thumb/' . $record['image'])) : '';
                        } else {
                            $thumb = 'Not found';
                        }
                        return 'O : ' . $original . '<br/>' . 'T : ' . $thumb;
                    })
                    ->editColumn('created_at', function ($record) {
                        return $record->created_at->format(config('app.display_date'));
                    })
                    ->addColumn('status', function ($record) {
                        return '<input id="toggle-demo" value="' . $record->id . '" class="chk_status" data-toggle="toggle" data-on="Active" data-off="Inactive" data-size="small" data-onstyle="success"  type="checkbox" ' . ($record->status == "Active" ? " checked" : "" ) . ' >';
                    })
                    ->addColumn('action', function ($record) {
                        return '<a href="' . route($this->data['route'] . 'show', ['id' => $record->id]) . '" class="btn btn-primary btn-sm" title="" data-toggle="tooltip" data-original-title="View"><i class="fa fa-eye-slash"></i></a>' .
                                '&nbsp;<a href="' . route($this->data['route'] . 'edit', ['id' => $record->id]) . '" class="btn btn-info btn-sm" title="" data-toggle="tooltip" data-original-title="Edit"><i class="fa fa-pencil"></i></a>' .
                                '&nbsp;<button class="btn btn-danger btn-sm data-delete" data-id="' . $record->id . '" data-toggle="tooltip" data-original-title="Delete"><i class="fa fa-trash"></i></button>';
                    })
                    ->rawColumns(['status','action','image','sequence','image_size','deletemultiple'])
                    ->make(true);
        }
       
        return view('admin.category.index', $this->data);
        
    }

    public function create() {
        abort_unless(Auth::guard('admin')->user()->hasAnyPermission(['category add']), 403);
        return view('admin.category.create', $this->data);
    }

    public function store(Request $request) {
        abort_unless(Auth::guard('admin')->user()->hasAnyPermission(['category add']), 403);
        $this->_validate($request);
        $input = $request->all();
        $input['image'] = $this->uploadFile($request, null, 'image', 'category', false);
        $record = new Category($input);
        $record->save();

        Session::flash('success', $this->data['title'] . ' inserted successfully.');
        return redirect()->route($this->data['route'] . 'index');
    }

    public function show($id) {

        abort_unless(Auth::guard('admin')->user()->hasAnyPermission(['category view']), 403);

        $this->data['record'] = Category::findOrFail($id);
        return view('admin.category.show', $this->data);
    }

    public function edit($id) {
        abort_unless(Auth::guard('admin')->user()->hasAnyPermission(['category edit']), 403);

        $this->data['record'] = Category::findOrFail($id);
        return view('admin.category.create', $this->data);
    }

    public function update(Request $request, $id) {
        abort_unless(Auth::guard('admin')->user()->hasAnyPermission(['category edit']), 403);
        $record = Category::findOrFail($id);
        /* Change Status Block */
        if ($request->ajax()) {
            $record->update($request->all());
            return \Illuminate\Support\Facades\Response::json(['result' => 'success']);
        }
        $this->_validate($request, $id);
        $input = $request->all();
        $input['image'] = $this->uploadFile($request, $record, 'image', 'category', false);
        if (empty($input['image'])) {
            unset($input['image']);
        }
        $record->update($input);

        Session::flash('info', $this->data['title'] . ' updated successfully.');
        return redirect()->route($this->data['route'] . 'index');
    }

    public function destroy($id) {
        abort_unless(Auth::guard('admin')->user()->hasAnyPermission(['category delete']), 403);

        $record = Category::findOrFail($id);
        $this->deleteFile($record,'image',false);
        $record->delete();
        return \Illuminate\Support\Facades\Response::json([
                    'result' => 'success',
                    'message' => 'Deleted Data successfully!']);
    }
	
	public function deletemultiple(Request $request) {
		abort_unless(Auth::guard('admin')->user()->hasAnyPermission(['category delete']), 403);

        $record = Category::whereIn('id', $request->id)->get();
		foreach ($record as $key => $value) {
            $value->delete();
			$this->deleteFile($value,'image',false);
        }
        return 1;
    }

}
