<?php

namespace App\Http\Controllers\AdminAuth;

use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\Session;
use Yajra\Datatables\Datatables;
use Illuminate\Support\Facades\Auth;
use App\Model\Board;

class BoardController extends Controller {

    private $data = array(
        'route' => 'admin.board.',
        'title' => 'Board',
        'menu' => 'dropdown',
        'submenu' => 'board',
    );

    public function __construct() {
        $this->middleware(['permission:publish |board view|board add|board edit|board delete']);
    }

    private function _validate($request, $id = null) {
        $this->validate($request, [
            'name' => 'required|max:255',
        ]);
    }

    public function index(Request $request) {

        abort_unless(Auth::guard('admin')->user()->hasAnyPermission(['board view']), 403);

        if ($request->ajax()) {
            $records = Board::select('*');
			
            return Datatables::of($records)
                    ->editColumn('created_at', function ($record) {
                        return $record->created_at->format(config('app.display_date'));
                    })
                    ->addColumn('status', function ($record) {
                        return '<input id="toggle-demo" value="' . $record->id . '" class="chk_status" data-toggle="toggle" data-on="Active" data-off="Inactive" data-size="small" data-onstyle="success"  type="checkbox" ' . ($record->status == "Active" ? " checked" : "" ) . ' >';
                    })
                    ->addColumn('action', function ($record) {
                        return '<a href="' . route($this->data['route'] . 'show', ['id' => $record->id]) . '" class="btn btn-primary btn-sm" title="" data-toggle="tooltip" data-original-title="View"><i class="fa fa-eye-slash"></i></a>' .
                                '&nbsp;<a href="' . route($this->data['route'] . 'edit', ['id' => $record->id]) . '" class="btn btn-info btn-sm" title="" data-toggle="tooltip" data-original-title="Edit"><i class="fa fa-pencil"></i></a>' .
                                '&nbsp;<button class="btn btn-danger btn-sm data-delete" data-id="' . $record->id . '" data-toggle="tooltip" data-original-title="Delete"><i class="fa fa-trash"></i></button>';
                    })
                    ->rawColumns(['status','action'])
                    ->make(true);
        }
        return view('admin.board.index', $this->data);
        
    }

    public function create() {

        abort_unless(Auth::guard('admin')->user()->hasAnyPermission(['board add']), 403);

        return view('admin.board.create', $this->data);
    }

    public function store(Request $request) {

        abort_unless(Auth::guard('admin')->user()->hasAnyPermission(['board add']), 403);

        $this->_validate($request);
        $input = $request->all();
        $record = new Board($input);
        $record->save();
		
        Session::flash('success', $this->data['title'] . ' inserted successfully.');
        return redirect()->route($this->data['route'] . 'index');
    }

    public function show($id) {

        abort_unless(Auth::guard('admin')->user()->hasAnyPermission(['board view']), 403);

        $this->data['record'] = Board::findOrFail($id);
        return view('admin.board.show', $this->data);
    }

    public function edit($id) {

        abort_unless(Auth::guard('admin')->user()->hasAnyPermission(['board edit']), 403);

        $this->data['record'] = Board::findOrFail($id);
        return view('admin.board.create', $this->data);
    }

    public function update(Request $request, $id) {

        abort_unless(Auth::guard('admin')->user()->hasAnyPermission(['board edit']), 403);

        $record = Board::findOrFail($id);
        /* Change Status Block */
        if ($request->ajax()) {
            $record->update($request->all());
            return \Illuminate\Support\Facades\Response::json(['result' => 'success']);
        }
        $this->_validate($request, $id);
        $input = $request->all();
        $record->update($input);

        Session::flash('info', $this->data['title'] . ' updated successfully.');
        return redirect()->route($this->data['route'] . 'index');
    }

    public function destroy($id) {

        abort_unless(Auth::guard('admin')->user()->hasAnyPermission(['board delete']), 403);

        $record = Board::findOrFail($id);
        $record->delete();
        return \Illuminate\Support\Facades\Response::json([
                    'result' => 'success',
                    'message' => 'Deleted Data successfully!']);
    }

}
