<?php

namespace App\Console;

use Illuminate\Console\Scheduling\Schedule;
use Illuminate\Foundation\Console\Kernel as ConsoleKernel;

class Kernel extends ConsoleKernel
{
    /**
     * The Artisan commands provided by your application.
     *
     * @var array
     */
    protected $commands = [
        Commands\HardikCrud::class,
        Commands\HardikController::class,
        Commands\HardikModel::class,
        Commands\HardikView::class,
    ];

    /**
     * Define the application's command schedule.
     *
     * @param  \Illuminate\Console\Scheduling\Schedule  $schedule
     * @return void
     */
    protected function schedule(Schedule $schedule)
    {
        // $schedule->command('inspire')
        //          ->hourly();
        
        $schedule->call(function () {
            $skip = '0';
            $limit = '100';
            $message = \App\Model\Message::whereDate('notify_time', '<=', \Carbon\Carbon::now())
                            ->where('ios_completed', '0')->first();
            if (!empty($message)) {
                while (true) {
                    $users = \App\User::select(['id'])->where('device', 'ios')->skip($skip)->take($limit)->get();
                    if ($users->count() == '0') {
                        $message->ios_completed = '1';
                        $message->save();
                        break;
                    }
                    
                    $message->ios_skip = $skip;
                    $message->ios_total_sent = $message->ios_total_sent + $users->count();
                    $message->save();
                    //return $users->pluck('id');
                    
                    $skip = $skip + $limit;
                    //sleep(5);
                    //echo 'works \n<br/>';
                }
            }
        })->everyMinute();
    }

    /**
     * Register the Closure based commands for the application.
     *
     * @return void
     */
    protected function commands()
    {
        require base_path('routes/console.php');
    }
}
