<?php

namespace App\Console\Commands;

use Illuminate\Console\Command;
use Illuminate\Console\GeneratorCommand;
use Illuminate\Support\Str;
use Illuminate\Filesystem\Filesystem;
use Symfony\Component\Console\Input\InputArgument;

class HardikView extends GeneratorCommand
{
    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'hardik:view {name}';
    protected $files;
    protected $view_folder = '/admin';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'Generate index.blade, create.blade, show.blade, form.blade Views file for CRUD.';

    /**
     * Create a new command instance.
     *
     * @return void
     */
//    public function __construct()
//    {
//        parent::__construct();
//    }

    /**
     * Execute the console command.
     *
     * @return mixed
     */
    public function handle()
    {
        //$name = $this->argument('name');
        $name = strtolower($this->argument('name'));
        
        // Create Index Blade file
        $index = '../resources/views'.$this->view_folder.'/'.$name.'/index';
        $index_path = $this->getPath($index);
        
        $this->makeDirectory($index_path);
        
        $this->files->put($index_path, $this->buildClass2($name,'index'));
        
        // Create Create Blade file
        $create = '../resources/views'.$this->view_folder.'/'.$name.'/create';
        $create_path = $this->getPath($create);
        $this->files->put($create_path, $this->buildClass2($name,'create'));
        
        // Create Show Blade
        $show = '../resources/views'.$this->view_folder.'/'.$name.'/show';
        $show_path = $this->getPath($show);
        $this->files->put($show_path, $this->buildClass2($name,'show'));
        
        // Create Form blade
        $form = '../resources/views'.$this->view_folder.'/'.$name.'/form';
        $form_path = $this->getPath($form);
        $this->files->put($form_path, $this->buildClass2($name,'form'));
        
        $this->info($name .' views created successfully.');
    }
    protected function getStub()
    {
        return __DIR__.'/stubs/view_index.stub';
    }
    protected function getIndexStub()
    {
        return __DIR__.'/stubs/view_index.stub';
    }
    protected function getCreateStub()
    {
        return __DIR__.'/stubs/view_create.stub';
    }
    protected function getShowStub()
    {
        return __DIR__.'/stubs/view_show.stub';
    }
    protected function getFormStub()
    {
        return __DIR__.'/stubs/view_form.stub';
    }
    protected function getControllerStub()
    {
        return __DIR__.'/stubs/controller.stub';
    }
    
    
    
    protected function getPath($name)
    {
        $name = str_replace_first($this->rootNamespace(), '', $name);
        return $this->laravel['path'].'/'.str_replace('\\', '/', $name).'.blade.php';
    }
    protected function getPath2($name)
    {
        $name = str_replace_first($this->rootNamespace(), '', $name);
        return $this->laravel['path'].'/'.str_replace('\\', '/', $name).'.php';
    }
    

    protected function makeDirectory($path)
    {
        if (! $this->files->isDirectory(dirname($path))) {
            $this->files->makeDirectory(dirname($path), 0777, true, true);
        }

        return $path;
    }

    protected function buildClass2($name,$stub_file)
    {
        if($stub_file == 'index')
            $stub = $this->files->get($this->getIndexStub());
        else if($stub_file == 'create')
            $stub = $this->files->get($this->getCreateStub());
        else if($stub_file == 'show')
            $stub = $this->files->get($this->getShowStub());
        else if($stub_file == 'form')
            $stub = $this->files->get($this->getFormStub());
        else if($stub_file == 'controller')
            $stub = $this->files->get($this->getControllerStub());
        
        return $this->replaceNamespace($stub, $name)->replaceClass($stub, $name);
    }

    protected function replaceNamespace(&$stub, $name)
    {
//        $stub = str_replace(
//            ['DummyNamespace', 'DummyRootNamespace'],
//            [$this->getNamespace($name), $this->rootNamespace()],
//            $stub
//        );
        $stub = str_replace(
            ['DummyNamespace', 'DummyRootNamespace'],
            ['App\Http\Controllers\AdminAuth', $this->rootNamespace()],
            $stub
        );
        return $this;
    }

    protected function getNamespace($name)
    {
        return trim(implode('\\', array_slice(explode('\\', $name), 0, -1)), '\\');
    }

    protected function replaceClass($stub, $name)
    {
        $class = str_replace($this->getNamespace($name).'\\', '', $name);
        $stub = str_replace('DummyRoute', $class, $stub);
        $stub = str_replace('DummyTitle', ucwords($name), $stub);
        $stub = str_replace('DummyMenu', strtolower($name),$stub);
        $stub = str_replace('DummyClass', ucfirst($name).'Controller',$stub);
        
        
        return str_replace('DummyRoute', $class, $stub);
    }
    
    protected function rootNamespace()
    {
        return $this->laravel->getNamespace();
    }
}
