<?php

namespace App\Console\Commands;

use Illuminate\Console\Command;
use Illuminate\Console\GeneratorCommand;
use Illuminate\Support\Str;
use Illuminate\Filesystem\Filesystem;
use Symfony\Component\Console\Input\InputArgument;

class HardikTest extends GeneratorCommand
{
    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'hardik:test {name?}';
    protected $type;
    protected $files;

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'Command description';

    /**
     * Create a new command instance.
     *
     * @return void
     */
//    public function __construct()
//    {
//        parent::__construct();
//    }

    /**
     * Execute the console command.
     *
     * @return mixed
     */
    public function handle()
    {
        $name = $this->ask('Enter CRUD name!');
        //$this->info('You are entered : '.$name);
        
        // Create Model And Controller
        $this->call('make:model',['name'=>$name]);
        $this->call('make:controller', ['name' => $name.'Controller','--model'=>$name]);
        
       
        $name = strtolower($name);

        // Create Index Blade file
        $index = '../resources/views/admin/'.$name.'/index';
        $index_path = $this->getPath($index);
        $this->makeDirectory($index_path);
        $this->files->put($index_path, $this->buildClass2($name,'index'));
        
        // Create Create Blade file
        $create = '../resources/views/admin/'.$name.'/create';
        $create_path = $this->getPath($create);
        $this->files->put($create_path, $this->buildClass2($name,'create'));
        
        // Create Show Blade
        $show = '../resources/views/admin/'.$name.'/show';
        $show_path = $this->getPath($show);
        $this->files->put($show_path, $this->buildClass2($name,'show'));
        
        // Create Form blade
        $form = '../resources/views/admin/'.$name.'/form';
        $form_path = $this->getPath($form);
        $this->files->put($form_path, $this->buildClass2($name,'form'));
        
        $this->info($name .' views created successfully.');
        
        // Add Resource Route in Route file
        $route = '../routes/admin.php';
        //$name = str_replace_first($this->rootNamespace(), '', $route);
        $route_path = $this->laravel['path'].'/'.str_replace('\\', '/', $route).'';
        $this->files->append($route_path, "Route::resource('".$name."','AdminAuth/". ucfirst($name)."Controller');");
        
        
          
        //$this->call('make:model',['name'=>'Test']);
        //$this->call('make:controller', ['name' => $argName.'Controller']);
        //$argName = $this->argument('name'); 
//        $name = $this->ask('What is your name?');
//        $this->info('You are entered : '.$name);
//        $this->error('Something went wrong!');
        
    }
     protected function getStub()
    {
        return __DIR__.'/stubs/index.stub';
    }
    protected function getIndexStub()
    {
        return __DIR__.'/stubs/index.stub';
    }
    protected function getCreateStub()
    {
        return __DIR__.'/stubs/create.stub';
    }
    protected function getShowStub()
    {
        return __DIR__.'/stubs/show.stub';
    }
    protected function getFormStub()
    {
        return __DIR__.'/stubs/show.stub';
    }
    
    protected function getPath($name)
    {
        $name = str_replace_first($this->rootNamespace(), '', $name);
        return $this->laravel['path'].'/'.str_replace('\\', '/', $name).'.blade.php';
    }

    protected function makeDirectory($path)
    {
        if (! $this->files->isDirectory(dirname($path))) {
            $this->files->makeDirectory(dirname($path), 0777, true, true);
        }

        return $path;
    }

    protected function buildClass2($name,$stub_file)
    {
        if($stub_file == 'index')
            $stub = $this->files->get($this->getIndexStub());
        else if($stub_file == 'create')
            $stub = $this->files->get($this->getCreateStub());
        else if($stub_file == 'show')
            $stub = $this->files->get($this->getShowStub());
        else
            $stub = $this->files->get($this->getFormStub());
        
        return $this->replaceNamespace($stub, $name)->replaceClass($stub, $name);
    }

    protected function replaceNamespace(&$stub, $name)
    {
        $stub = str_replace(
            ['DummyNamespace', 'DummyRootNamespace'],
            [$this->getNamespace($name), $this->rootNamespace()],
            $stub
        );
        return $this;
    }

    protected function getNamespace($name)
    {
        return trim(implode('\\', array_slice(explode('\\', $name), 0, -1)), '\\');
    }

    protected function replaceClass($stub, $name)
    {
        $class = str_replace($this->getNamespace($name).'\\', '', $name);
        return str_replace('DummyRoute', $class, $stub);
    }
    
    protected function rootNamespace()
    {
        return $this->laravel->getNamespace();
    }

}
