<?php

namespace App\Console\Commands;

use Illuminate\Console\Command;
use Illuminate\Filesystem\Filesystem;
use Illuminate\Support\Facades\File;

class HardikCrud extends Command
{
    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'hardik:crud';
    protected $files;

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'Generate index.blade, create.blade, show.blade, form.blade Views file for CRUD.';

    /**
     * Create a new command instance.
     *
     * @return void
     */
    public function __construct()
    {
        parent::__construct();
    }

    /**
     * Execute the console command.
     *
     * @return mixed
     */
    public function handle()
    {
        $name = $this->ask('Enter CRUD name!');
        
        //$this->call('make:migration',['name'=>"create_".str_plural($name)."_table",'--create'=> str_plural($name)]);
        //$this->call('hardik:model',['name'=> ucwords($name)]);
        $this->call('hardik:controller',['name'=> ucwords($name)]);
        $this->call('hardik:view',['name'=> ucwords($name)]);
        
        // Add Resource Route in Route file
        $route = '../routes/admin.php';
        $route_path = $this->laravel['path'].'/'.str_replace('\\', '/', $route).'';
        File::append($route_path, "\nRoute::resource('".$name."','AdminAuth\\". ucfirst($name)."Controller');");
    }
}
