<?php

namespace App;

use App\Notifications\AdminResetPassword;
use Illuminate\Notifications\Notifiable;
use Illuminate\Foundation\Auth\User as Authenticatable;
use Illuminate\Support\Facades\Storage;
use Illuminate\Database\Eloquent\SoftDeletes;
use Illuminate\Database\Eloquent\Model;
use Spatie\Permission\Traits\HasRoles;

class Admin extends Authenticatable
{
    use HasRoles;
    use Notifiable;
    protected $appends = ['image_url','image_thumb_url','logo_url'];
    /**
     * The attributes that are mass assignable.
     *
     * @var array
     */
    protected $fillable = [
        'name', 'email', 'password','school_name','address','image','status','start_date','end_date','logo'
    ];

    /**
     * The attributes that should be hidden for arrays.
     *
     * @var array
     */
    protected $hidden = [
        'password', 'remember_token',
    ];

    /**
     * Send the password reset notification.
     *
     * @param  string  $token
     * @return void
     */
    public function sendPasswordResetNotification($token)
    {
        $this->notify(new AdminResetPassword($token));
    }
    public function getLogoUrlAttribute($value)
    {
        return Storage::exists($this->attributes['logo'])? Storage::url($this->attributes['logo']):null;
    }
    
    public function getImageUrlAttribute($value)
    {
        return Storage::exists($this->attributes['image'])? Storage::url($this->attributes['image']):null;
    }
    public function getImageThumbUrlAttribute($value)
    {
        return Storage::exists( $this->attributes['image'])? Storage::url('thumb/'.$this->attributes['image']):null;
    }
}
